/**
 * Created by Jozo on 16/9/22.
 */
/*
 * Check out the full guide at
 *   http://sipjs.com/guides/make-call/
 *
 * This sample uses
 *   http://sipjs.com/download/sip-0.7.0.min.js
 *
 * Login with your developer account to receive calls at
 *   http://sipjs.com/demo-phone
 */

document.write("<script src='./sdk/yunUCSConnect.min.js'></script>");
var session;


var arr_domain = ['ipcc.ucpaas.com', '113.31.16.201', '113.31.21.234'];
var arr_wss = ['wss://ipcc.ucpaas.com:5164', 'wss://113.31.16.201:5164', 'wss://113.31.21.234:7443'];

var arr_username = ['62585050566263', '62585050566264', '63789050566265', '63789050566304'];
var arr_password = ['2d7b7790', '14f3622d', '27ea0488', '4c3995d2'];
var arr_displayName = ['62585050566263', '62585050566264', '63789050566265', '63789050566304'];

var options = {
    domain:null,
    wssServer: null,
    remote_ele: 'remoteAudio',
    local_ele: 'localAudio'
};

$(function() {
    UCSConnect.init(callback);
});

var callback = {

    // 登录回调
    OnLoginRet: function (message, ret) {
        //alert(message + '\n' + ret);
        printLog('登陆回调\n'  + message + '\nret:' + ret);
    },

    // 登出回调
    OnLogoutRet: function(message, ret) {
        //alert(message + '\n' + ret);
        printLog('登出回调\n'  + message + '\nret:' + ret);
    },

    // 来电回调
    OnIncomingCall: function(callID, caller, message) {
        //alert( caller + '\n' + callID);
        printLog('收到来电\n'  + message);
    },

    // 通话状态回调
    OnOutCallStatus: function(message, ret) {

        // 打印msg
        console.log("----------------\n\n通话状态变更\n" + message + "\n\n----------------");

        var str_ret;
        if (ret === 1) {
            str_ret = '拨号中';
        } else if (ret === 2) {
            str_ret = '被叫接听';
        } else if (ret === 3) {
            str_ret = '被叫拒接';
        } else if (ret === 4) {
            str_ret = '通话挂断';
        } else if (ret === 5) {
            str_ret = '主叫取消';
        } else if (ret === 6) {
            str_ret = '通话结束';
        } else if (ret === 7) {
            str_ret = '异常操作';
        }

        printLog(str_ret + "\n" + message + '\nret:' + ret);
        //alert('OnOutCallStatus\n' + callId + '\n' + ret + '\n' + callType + '\n' + peerNumber);
    },

    // 通话结束回调
    OnCallGiveUp: function(message, cause) {

        var str_ret = '通话已结束';
        printLog(str_ret + "\n" + message);
    },

    // 异常回调
    OnExcepting: function(message, cause) {

        var str_ret = '异常事件';
        //printLog(str_ret + "\n" + message + '\ncause:' + cause);
    }
};

function fillDomain(){
    var objS = document.getElementById("select_domain");
    var index = objS.selectedIndex - 1;

    $('#domain_init').val(arr_domain[index]);
    $('#wss_init').val(arr_wss[index]);

}


function fillLoginUser(){
    var objS = document.getElementById("select_login_user");
    var index = objS.selectedIndex - 1;
    $('#username_login').val(arr_username[index]);
    $('#password_login').val(arr_password[index]);
    $('#displayName_login').val(arr_displayName[index]);
}

function fillCalled(){
    var objS = document.getElementById("select_called");
    var index = objS.selectedIndex - 1;
    $('#username_called').val(arr_username[index]);

}


function settingAction() {

    var domain = $('#domain_init').val();
    var wssServer = $('#wss_init').val();

    options.domain = domain;
    options.wssServer = wssServer;

    printLog('修改配置\ndomain:'  + domain + '\nwssServer:' + wssServer);
}

function loginAction() {



    var username = $('#username_login').val();
    var password = $('#password_login').val();
    var displayName = $('#displayName_login').val();

    UCSConnect.login(username, password, displayName);

}

function logoutAction() {
    UCSConnect.logout();
}


function startAction() {

    var called = $('#username_called').val();
    UCSConnect.SendOutCall(called);

}


function answerAction() {
    UCSConnect.AnswerCall();
}

function rejectAction() {
    UCSConnect.CallReject();
}

function endAction() {
    UCSConnect.CallGiveUp();
}

function cancelAction() {
    UCSConnect.cancel();
}


function cleanAction() {
    $('#text_log').val('');
}


// 打印信息到页面
function printLog(str) {
    var val_tmp = '\n\n----------------' + '\n\n*********************************************************************************************\n\n';
    var val_old = $('#text_log').val();
    var val_new = '----------------\n\n' + str + val_tmp + val_old;
    $('#text_log').val(val_new);
}
