var express = require('express');
var ejs = require('ejs');
var swig = require('swig');
var path = require('path');
var favicon = require('serve-favicon');
var logger = require('morgan');
var cookieParser = require('cookie-parser');
var bodyParser = require('body-parser');

var index = require('./routes/index');
var users = require('./routes/users');

var app = express();

// view engine setup
// app.set('views', path.join(__dirname, 'views'));
// app.set('view engine', 'ejs');




// app.engine('html',ejs.__express);
// app.set('view engine', 'html');


app.engine('html', swig.renderFile);
//设置文件存在的目录，第一个参数必须是'views',第二个参数是目录
app.set('views', './views');

//注册所使用的模板引擎，第一个参数必须是 view engine,第二个参数必须和app.engine中第一个参数一致
app.set('view engine', 'html');

swig.setDefaults({ cache: false });

// 设置静态目录
app.use('/public', express.static(__dirname + '/public'));






// uncomment after placing your favicon in /public
//app.use(favicon(path.join(__dirname, 'public', 'favicon.ico')));
app.use(logger('dev'));
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: false }));
app.use(cookieParser());
// app.use(express.static(path.join(__dirname, 'public')));	







app.use('/', index);
app.use('/users', users);

// catch 404 and forward to error handler
app.use(function(req, res, next) {
  var err = new Error('Not Found');
  err.status = 404;
  next(err);
});

// error handler
app.use(function(err, req, res, next) {
  // set locals, only providing error in development
  res.locals.message = err.message;
  res.locals.error = req.app.get('env') === 'development' ? err : {};

  // render the error page
  res.status(err.status || 500);
  res.render('error');
});

module.exports = app;
